/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.irrigation_tower;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.forsteri.ratatouille.content.irrigation_tower.IrrigationTowerBlockEntity;

public class IrrigationTowerRenderer
extends SafeBlockEntityRenderer<IrrigationTowerBlockEntity> {
    public IrrigationTowerRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(IrrigationTowerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        LerpedFloat fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float capHeight = 0.25f;
        float tankHullWidth = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.getHeight() - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(partialTicks);
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = Mth.clamp((float)(level * 8.0f * totalHeight), (float)0.0f, (float)totalHeight);
        FluidTank tank = be.getTankInventory();
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        boolean top = fluidStack.getFluid().getFluidType().isLighterThanAir();
        float xMin = tankHullWidth + 0.125f;
        float xMax = xMin + (float)be.getWidth() - 2.0f * tankHullWidth - 0.25f;
        float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel + 0.1875f;
        float yMax = yMin + clampedLevel + 0.375f;
        if (top) {
            yMin += totalHeight - clampedLevel;
            yMax += totalHeight - clampedLevel;
        }
        float zMin = tankHullWidth + 0.125f;
        float zMax = zMin + (float)be.getWidth() - 2.0f * tankHullWidth - 0.25f;
        ms.pushPose();
        ms.translate(0.0f, clampedLevel - totalHeight, 0.0f);
        NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, bufferSource, ms, light, false, true);
        ms.popPose();
    }
}

